/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Enum;
import org.apache.axis.constants.Style;
import org.apache.axis.wsdl.symbolTable.BindingEntry;

public class WSBinding {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSBinding";
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    private WSDefinition m_definition = null;
    private Binding m_binding = null;
    private ExtensibilityElement m_soapBinding = null;
    private HTTPBinding m_httpBinding = null;
    private BindingEntry m_bindingEntry = null;
    private WSBindingOperation[] m_bindingOperations = null;
    private int m_bindingType = 3;
    private String m_bindingTypeString = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.12  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                this.m_definition = null;
                this.m_binding = null;
                this.m_soapBinding = null;
                this.m_httpBinding = null;
                this.m_bindingEntry = null;
                this.m_bindingTypeString = null;
                if (this.m_bindingOperations != null) {
                    WSBindingOperation[] bindingOperations = this.m_bindingOperations;
                    this.m_bindingOperations = null;
                    for (int i = 0; i < bindingOperations.length; ++i) {
                        if (bindingOperations[i] == null) continue;
                        bindingOperations[i].releaseReferences();
                        bindingOperations[i] = null;
                    }
                    bindingOperations = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSBinding(WSDefinition definition, Binding binding) throws Exception {
        this.m_definition = definition;
        this.m_binding = binding;
        if (binding != null) {
            this.m_bindingEntry = this.m_definition.m_symTable.getBindingEntry(binding.getQName());
            int bindingType = this.m_bindingEntry.getBindingType();
            List l = binding.getExtensibilityElements();
            Iterator it = l.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj == null) continue;
                    if (obj instanceof SOAPBinding) {
                        this.m_soapBinding = (SOAPBinding)obj;
                        continue;
                    }
                    if (obj instanceof HTTPBinding) {
                        this.m_httpBinding = (HTTPBinding)obj;
                        continue;
                    }
                    if (!(obj instanceof UnknownExtensibilityElement) || bindingType != 0) continue;
                    this.m_soapBinding = (ExtensibilityElement)obj;
                }
            }
        }
        this.init();
    }

    public void init() throws Exception {
        if (this.m_bindingEntry != null) {
            this.m_bindingType = this.m_bindingEntry.getBindingType();
        }
        switch (this.m_bindingType) {
            case 0: {
                this.m_bindingTypeString = "SOAP Binding";
                break;
            }
            case 1: {
                this.m_bindingTypeString = "HTTP_GET Binding";
                break;
            }
            case 2: {
                this.m_bindingTypeString = "HTTP_POST Binding";
                break;
            }
            case 3: {
                this.m_bindingTypeString = "Unknown Binding";
            }
        }
        this.initBindingOperations();
    }

    private void initBindingOperations() throws Exception {
        List l;
        if (this.m_binding != null && (l = this.m_binding.getBindingOperations()) != null && l.size() > 0) {
            this.m_bindingOperations = new WSBindingOperation[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object obj = l.get(i);
                if (!(obj instanceof BindingOperation)) continue;
                this.m_bindingOperations[i] = new WSBindingOperation(this.m_definition, this, (BindingOperation)obj);
            }
        }
    }

    public String getName() {
        QName name;
        if (this.m_binding != null && (name = this.m_binding.getQName()) != null) {
            return name.getLocalPart();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_binding != null) {
            return this.m_binding.getQName().getLocalPart();
        }
        return null;
    }

    public QName getQName() {
        if (this.m_binding != null) {
            return this.m_binding.getQName();
        }
        return null;
    }

    public Binding getBinding() {
        return this.m_binding;
    }

    public BindingEntry getBindingEntry() {
        return this.m_bindingEntry;
    }

    public WSBindingOperation[] getBindingOperations() {
        return this.m_bindingOperations;
    }

    public String toString() {
        return this.getName();
    }

    public int getBindingType() {
        return this.m_bindingEntry.getBindingType();
    }

    public ExtensibilityElement getSoapBinding() {
        return this.m_soapBinding;
    }

    public String getSoapStyle() {
        if (this.m_soapBinding != null && this.m_soapBinding instanceof SOAPBinding) {
            return ((SOAPBinding)this.m_soapBinding).getStyle();
        }
        if (this.m_bindingEntry != null) {
            Style style = this.m_bindingEntry.getBindingStyle();
            if (style != null && style.equals((Enum)Style.DOCUMENT)) {
                return "document";
            }
            if (style != null && style.equals((Enum)Style.MESSAGE)) {
                return "message";
            }
            if (style != null && style.equals((Enum)Style.RPC)) {
                return "rpc";
            }
            if (style != null && style.equals((Enum)Style.WRAPPED)) {
                return "wrapped";
            }
        }
        return null;
    }

    public String getSoapTransportURI() {
        if (this.m_soapBinding != null && this.m_soapBinding instanceof SOAPBinding) {
            return ((SOAPBinding)this.m_soapBinding).getTransportURI();
        }
        return null;
    }

    public HTTPBinding getHTTPBinding() {
        return this.m_httpBinding;
    }

    public String getHTTPVerb() {
        if (this.m_httpBinding != null) {
            return this.m_httpBinding.getVerb();
        }
        return null;
    }
}

